import numpy as np
import matplotlib.pyplot as plt

tmax = 2
dt = 0.1
t = np.arange(0, tmax, dt)     # time array
a = 10
pos = .5 * a * t**2        	# simulate experimental data for x(t)
plt.plot(t, pos, 'o-')			# mark points as circles

vel= np.gradient(pos)/dt
plt.plot(t, vel, 'x-')  	# mark points as crosses

accn = np.gradient(vel)/dt  	# use the numpy function to get gradient
print(accn)
plt.plot(t, accn, 's-')	# mark points as squares
plt.show()


