import numpy as np
from scipy import integrate
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

fig = plt.figure(figsize=plt.figaspect(1.))
ax = fig.add_subplot(projection = '3d')

m = 1.67e-27        # proton mass in Kg
q = 1.60217663e-19  # proton charge in Coulombs
vx = 3.9e6          # velocity of 80keV proton in meter/sec       
Bz = .82            # magnetic field in tesla
E = np.array([0, 0, 0.1])   # Electric field components Ex,Ey & Ez in volts
B = np.array([0, 0, Bz])  # Magnetic field 

def solver(X, t0): # X is a six element array, t0 required for the solver
	v = np.array([X[3], X[4], X[5]])  # make the velocity vector
	a = q * (E + np.cross(v,B)) / m   # F = q v x B ; a = F/m
	return [X[3], X[4], X[5], a[0], a[1], a[2]]	

tmax = 79.e-8  # calculate up to 			
x0 = [0, 0, 0, vx, 0, 0]					# position & velocity, at t = 0
t = np.linspace(0, tmax, 10000)	   			# array of time coordinate
pv = integrate.odeint(solver, x0, t)	# integrate for position and velocity

ax.plot(pv[:,0], pv[:,1], pv[:,2])			# 3d plot of x, y and z
ax.set_zlabel('Z axis')
plt.show()
