# Two dimensional motion, trajectory calculation using scipy.integrate
import numpy as np
import matplotlib.pyplot as plt
from scipy import integrate

ax = .0     # Horizontal acceleration
ay = -9.8	# Vertical acceleration

def deriv(PV, t0):   # PV contains x,y,vx,vy
	return [ PV[2], PV[3], ax, ay ]   # ax = dVx/dt, ay = dVy/dt

dt = .1
t = np.arange(0, 5, dt) # time array
pv0 = [0,0, 20, 20]  # x, y, Vx and Vy,  at t = 0
pv = integrate.odeint(deriv, pv0, t)	# integrate for position and velocity

plt.scatter(pv[:,0], pv[:,1])   # X and Y
plt.show()
