import numpy as np
import matplotlib.pyplot as plt
from scipy import integrate
L = 5  # decay constant

def derivative(y, t0):  	
	return -L * y		# dN/dt = -L * N , radioactive decay

N = 1000				# value at t = 0
dt = 0.01
t = np.arange(0, 1, dt)	    	# time span and steps

nt = integrate.odeint(derivative, N, t)		# integrate
plt.plot(t, nt[:,0])  # extract the first column from the 2D array
plt.show()
