'''
Evaluate sine function from it's derivative using Euler and RK4 methods.
Plot their deviation from function sin().
'''

import numpy as np
import matplotlib.pyplot as plt

def f1(x,y):		# derivative of the function to be evaluated
	return np.cos(x)

def euler(x, y, fxy, h):
	return y + h * fxy(x,y)   # Euler method
	
def rk4(x, y, fxy, h):   # x, y , f(x,y)
	k1 = h * fxy(x, y)
	k2 = h * fxy(x + h/2.0, y+k1/2)
	k3 = h * fxy(x + h/2.0, y+k2/2)
	k4 = h * fxy(x + h, y+k3)
	return  y + ( k1/6 + k2/3 + k3/3 + k4/6 )
	
dx = .1		# step size
xmin = 0	# initial value 
xmax = np.pi	# calculate up to this only

xa = np.arange(xmin, xmax, dx)	# array of the independent variable
N =len(xa)
ya = np.empty(N)	# numpy array to store results
sf = np.sin(xa)		# sine function

ya[0] = 0.0	# given initial value

for i in range(N-1):
	ya[i+1] = euler(xa[i], ya[i], f1, dx)
plt.plot(xa, ya-sf, 'x')    # error in Euler method

for i in range(N-1):
	ya[i+1] = rk4(xa[i], ya[i], f1, dx)
plt.plot(xa, ya-sf, 'o')    # error in RK4 method  

plt.show()

   
