import numpy as np
import matplotlib.pyplot as plt

x = [0,2,4,6]
y = [0,8,64,216]
n = len(x)

nx = np.linspace(0,6,11)  # 11 equispaced values of x from 0 to 3
h = x[1] - x[0]

p = (nx-x[0])/h
deltas = [8, 48, 48]   #from difference table, forward
ny = y[0] + p*deltas[0] + p*(p-1)*deltas[1]/2 + p*(p-1)*(p-2)*deltas[2]/6
plt.plot(nx,ny, 'x', label='Forward')  # by forward difference method


p = (nx-x[-1])/h
deltas = [152, 96, 48]   #from difference table, backward
ny = y[-1] + p*deltas[0] + p*(p+1)*deltas[1]/2 + p*(p+1)*(p+2)*deltas[2]/6
plt.plot(nx,ny, '+', label='Backward')  # by backward difference method

plt.plot(x,y, 'o', label='Data points')    # given data points
plt.plot(nx, nx**3, label = '$y=x^3$')     # analytical value
plt.legend(framealpha=0.5)
plt.show()
