'''
Initial Value Problem with Ordinary Differential Equations. 
We choose a known functions so that the result can be cross checked. 

dy/dx = cos(x) and y(0) = 0  are given.
'''

import numpy as np
import matplotlib.pyplot as plt

def f1(x,y):		# derivative of the function to be evaluated
	return np.cos(x)

def euler(x, y, fxy, h):
	return y + h * fxy(x,y)   # Euler method
	
dx = .5		# step size
xmin = 0	# initial value 
xmax = np.pi	# calculate up to this only

xa = np.arange(xmin, xmax, dx)	# array of the independent variable
N =len(xa)
ya = np.empty(N)	# numpy array to store results

ya[0] = 0.0	# given initial value


for i in range(N-1):
	ya[i+1] = euler(xa[i], ya[i], f1, dx)

plt.plot(xa, ya, 'x-')
plt.plot(xa, np.sin(xa), 'o-')
plt.show()

   
