import numpy as np

a = np.array( [ [2,1,-1,8], [-3,-1,2,-11], [-2,1,2,-3] ],dtype='float')
NR = len(a)
NC = NR + 1     # one more column, Augmented matrix

'''
Anchor is element A11 (python index [0,0])
The inner loop first entry : anchor = 0. row = 0 : Row2 -> Row2 - Row1 * A21/A11
The inner loop second entry: anchor = 0. row = 1 : Row3 -> Row3 - Row1 * A31/A11
Anchor shifts to element A22.
The inner loop third entry : anchor = 1. row = 1 : Row3 -> Row3 - Row3 * A32/A22
'''
for anchor in range(NR-1):
	for row in range(anchor, NR-1):
		print('anchor = %2d row = %2d\n'%(anchor,row))
		ratio = a[row+1,anchor]/a[anchor,anchor]
		a[row+1] = np.subtract(a[row+1],a[anchor]*ratio)
		print (a,'\n')
	
'''
Now we proceed to eliminate the upper half elements, using the same procedure.
The outer loop is running in reverse direction starting with element A33
Anchor is element A33 (python index [2,2])
The inner loop first entry : anchor = 2. row = 0 : Row1 -> Row1 - Row3 * A13/A33
The inner loop second entry: anchor = 2. row = 1 : Row2 -> Row2 - Row3 * A23/A33
Anchor shifts to element A22.
The inner loop third entry : anchor = 1. row = 1 : Row3 -> Row1 - Row1 * A12/A22
'''

for anchor in range(NR-1, 0,-1):   # looping for 2, 1, 
	for row in range(anchor):  
		print('anchor = %2d row = %2d\n'%(anchor,row))
		ratio = a[row,anchor]/a[anchor,anchor]
		a[row] = np.subtract(a[row],a[anchor]*ratio)
		print (a,'\n')

for row in range(NR):		#making all diagonal elements 1.
	if a[row,row] != 1:
		a[row] = a[row] / a[row,row]    
print (a,'\n')

