#Newton Raphson method
import numpy as np
import matplotlib.pyplot as plt

def f(x):
	return 2.0 * x**2 - 3*x - 5

def df(x):
	return 4.0 * x - 3

vf = np.vectorize(f)
x = np.linspace(-2, 5, 100)
y = vf(x)

x1 = 4
tg1 = df(x1)*(x-x1) + f(x1)
x1 = -3
tg2 = df(x1)*(x-x1) + f(x1)

plt.grid(True)
plt.plot(x,y)
plt.plot(x,tg1)
plt.plot(x,tg2)
plt.ylim([-20,40])
plt.show()
