'''
Solving initial value problem using 4th order Runge-Kutta method.
derivative depends on the value of the function.
f(x,y) = 2(y - x^2) + 1
'''
import numpy as np

def f1(x,y):             
       return 2*(y-x**2) + 1   # derivative

def rk4(x, y, fxy, h):   # x, y , f(x,y)
	k1 = h * fxy(x, y)
	k2 = h * fxy(x + h/2.0, y+k1/2)
	k3 = h * fxy(x + h/2.0, y+k2/2)
	k4 = h * fxy(x + h, y+k3)
	ny = y + ( k1/6 + k2/3 + k3/3 + k4/6 )
	return ny


dx = 0.1   # stepsize
xa = np.arange(0,1,dx)
N = len(xa)
ya = np.empty(N)  # to store y values
ya[0] = 0.0    # initial value

for k in range(N-1):
	ya[k+1] = rk4(xa[k], ya[k], f1, dx)
	
for k in range(N):
	print (xa[k], ya[k],  xa[k]**2 + xa[k]) 

