'''
Solve d^2y/dx^2 = -y
'''
    
import numpy as np
import matplotlib.pyplot as plt

dx = 0.1
xa = np.arange(0, 10, dx)	# array of x
N =len(xa)

def f1(y1,y2,x):	
	return y2   # derivative of y1 is y2

def f2(y1,y2,x):
	return -y1  # as per the equation 

def rk4(y1,y2, f1, f2, x, h):
	k11 = h*f1(y1,y2,x);
	k21 = h*f2(y1,y2,x);
	k12 = h*f1(y1+0.5*k11,y2+0.5*k21,x+0.5*h);
	k22 = h*f2(y1+0.5*k11,y2+0.5*k21,x+0.5*h);
	k13 = h*f1(y1+0.5*k12,y2+0.5*k22,x+0.5*h);
	k23 = h*f2(y1+0.5*k12,y2+0.5*k22,x+0.5*h);
	k14 = h*f1(y1+k13,y2+k23,x+h);
	k24 = h*f2(y1+k13,y2+k23,x+h);
	y1 += (k11+2*k12+2*k13+k14)/6;
	y2 += (k21+2*k22+2*k23+k24)/6;
	return y1,y2

y1a = np.zeros(N)		# array to store the computed y1
y2a = np.zeros(N)		# and y2
y1a[0] = 0				# initial values
y2a[0] = 2				# of y1 and y2
	
for i in range(N-1):
	y1a[i+1], y2a[i+1] = rk4(y1a[i], y2a[i], f1, f2, xa[i], dx)	
  
plt.plot(xa, y1a)
plt.plot(xa, y2a)
plt.show()  

