import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation as fa
from mpl_toolkits.mplot3d import Axes3D

fig = plt.figure()
ax = fig.add_subplot(projection = '3d')

z = np.linspace(0, 20, 100)
x = np.sin(z)
y = np.cos(z)

ax.axis('off')
ax.plot3D(x,y,z)


def animate(phi):
	ax.view_init(phi, phi) #both elevation and azimuth updated

anim = fa(fig, animate, frames=360, interval=10)
plt.show()
