import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation as fa

fig = plt.figure()
ax = fig.add_subplot()
print(ax)
x = np.linspace(-2*np.pi, 2*np.pi, 100)
L, =  ax.plot(x, np.sin(x))

def update(fnum):
	L.set_data(x, np.sin(x + 0.2 * fnum))

anim = fa(fig, update, frames=100, interval=50)
plt.show()

