import numpy as np
import matplotlib.pyplot as plt

from mpl_toolkits.mplot3d import Axes3D

fig = plt.figure()
ax = fig.add_subplot(projection = '3d')

x = np.linspace(-10, 10, 100)
y = np.linspace(-10, 10, 100)
xx, yy = np.meshgrid(x, y)

#z = xx ** 2 + yy **2    # also try with z = sin(xx) + sin(yy) 
z = np.sin(xx) + np.sin(yy) 
ax.plot_surface(xx, yy, z, cmap=plt.cm.jet, cstride=1)
plt.show()

