from numpy import * 
from scipy.special import sph_harm 

from pylab import * 
from mpl_toolkits.mplot3d import Axes3D
ax = Axes3D(figure())

polar = linspace(0,pi,100) 

azimuth = linspace(0, 2*pi,100) 

phi,th = meshgrid(polar, azimuth)

r = (0.5 * sqrt(3.0/pi) * cos(th))**2

#r = .25 * sph_harm(0,2,phi,th)

#r = 0.25 * sqrt(5.0/pi) * (3*cos(phi)**2 - 1)

x = r*sin(phi)*cos(th) 

y = r*cos(phi) 

z = r*sin(phi)*sin(th)

ax.plot_surface(x,y,z, rstride=1, cstride=1,cmap='viridis', edgecolor='none') 
show()
