import pandas as pd
from sklearn.linear_model import LinearRegression
from sklearn.model_selection import train_test_split
from sklearn.metrics import mean_squared_error

# 🧾 Sample dataset: size (sqft), bedrooms → price
data = {
    'area':  [900, 1100, 2000, 2200, 1100, 2500, 3000, 2800],
    'nfloors': [1,    1,    2,    2,    1,    2,    2,    2],
    'distance':[1,    3,    7,    4,    4,    5,   10,    2],
    'cost':   [50,   50,   80,   90,   45,   87,  120,  110]
}

# Convert to DataFrame
df = pd.DataFrame(data)
#df = pd.read_csv('house_prices.csv')

# Features and target
x = df[['area', 'nfloors','distance']]  # Input variables
y = df['cost']                     # Output variable

# Split into training and test sets
x_train, x_test, y_train, y_test = train_test_split(x, y, test_size=0.2, random_state=42)

# 🧠 Create and train the model
model = LinearRegression()
model.fit(x_train, y_train)

# 🔍 Make predictions
predictions = model.predict(x_test)
print(predictions)
print(y_test)
